/*
    magic.cc -  We bring good things to light!

    Marc Wolfgram and Mark Collins,  4/ 6/91 13:58:59
    ---------------------------------------------------------------
 */

#pragma noroot
#pragma keep "o/magic"

#include "shell.h"
#include <stdlib.h>
#include <qdaux.h>
#include <list.h>
#include <foundation.h>

extern word         workIndex, fResID;
extern char tempName[];
extern workFileRec  workList[];  /* work file array [0..3] */
extern remTypeLinkPtr rootREM;
extern long	*strings;

long copyManager(word, word, word, long, handle);

union control {
    Pointer                 dummy;
    SimpleButtonTemplate    *BcPtr;
    CheckBoxTemplate        *CBcPtr;
    IconButtonTemplate      *IcPtr;
    LineEditTemplate        *LEcPtr;
    ListTemplate            *LcPtr;
    PictureTemplate         *PcPtr;
    PopupTemplate           *PMcPtr;
    RectangleTemplate       *RcPtr;
    ScrollBarTemplate       *SBcPtr;
    SizeBoxTemplate         *GcPtr;
    TextEditTemplate        *TEcPtr;
    ThermometerTemplate     *TcPtr;
};
typedef union control control;

struct WinTemplate {
   Word plLength,
        plFrameBits;
   Long plTitle,
        plRefCon;
   Rect plZoom;
   Long plColor;
   Word plYOrigin,
        plXOrigin,
        plDataH,
        plDataW,
        plMaxH,
        plMaxW,
        plScrollVer,
        plScrollHor,
        plPageVer,
        plPageHor;
   Long plInfoText;
   Word plInfoHeight;
   Long plDefProc,
        plInfoDraw,
        plContentDraw;
   Rect plPosition;
   Long plPlane,
        plControlList;
   Word plInDesc;
};
typedef struct WinTemplate WinTemplate;

union wkPtr {
	char					*Ptr;
	word					*wPtr;
	long					*lPtr;
};
typedef union wkPtr wkPtr;

master MasterRace[] = { /* 1 = have children, 2 = have parent */
{ rIcon, 				2, 	{ rControlTemplate, rItemStruct, rBundle, 0 }},
{ rPicture, 			2, 	{ rControlTemplate, 0 }},
{ rControlList, 		3, 	{ rWindParam1, 0 }},
{ rControlTemplate,		3,	{ rControlList, rWindParam1, 0 }},
{ rC1InputString, 		2, 	{ rControlTemplate, 0 }},
{ rPString,				2,	{ rMenuItem, rControlTemplate, rMenu, rWindParam1, rItemStruct, rListRef, 0 }},
{ rMenuBar, 			1 },
{ rMenu, 				3, 	{ rMenuBar, rControlTemplate, 0 }},
{ rMenuItem, 			3, 	{ rMenu, 0 }},
{ rTextForLETextBox2, 	2,	{ rControlTemplate, 0 }},
{ rCtlColorTbl, 		2, 	{ rControlTemplate, 0 }},
{ rWindParam1, 			1 },
{ rWindColor, 			2, 	{ rWindParam1, 0 }},
{ rStyleBlock, 			2, 	{ rControlTemplate, 0 }},
{ rText, 				2, 	{ rControlTemplate, 0 }},
{ rListRef, 			3, 	{ rControlTemplate, 0 }},
{ rCString, 			2, 	{ rControlTemplate, 0 }},
{ rC1OutputString, 		2, 	{ rControlTemplate, 0 }},
{ rItemStruct, 			3, 	{ rMenuItem, 0 }},
{ rVersion,             2,  { rFinderPath, 0 }},
{ rBundle, 				1 },
{ rFinderPath, 			3, 	{ rBundle, 0 }},
{ 0 }};

word TEType[] = { rPString, rCString, rC1InputString, rC1OutputString, rTextForLETextBox2, rText };

segment "F_MISCCODE";

/*--------------------------------------
	getListCtlData

	Mark Collins and Marc Wolfgram,  1/11/92 18:30:20
*/
word getListCtlData(word *lMemSizeP, word *lCountP, long resID, word resFile)
{
word			retVal, hostState, count, i, listMemSize, listSize;
long			hostID;
namePtr			nameP;
nameSubPtr		nameSubP, listSubP;
handle			hostData;
control			ctl;

	retVal = listMemSize = listSize = 0;

	listSubP = getNameSubRec(workIndex, rListRef, resID);
	if (listSubP->hostType) {
		hostID = listSubP->hostID;
		hostData = SafeLoadResource2(&hostState, rControlTemplate, hostID, resFile);
		if (!toolerror()) {
	    	ctl.dummy = deref(hostData);
			if (ctl.LcPtr->ctlTemplate.procRef == listControl) {
				listMemSize = ctl.LcPtr->listMemSize;
				listSize = ctl.LcPtr->listSize;
				retVal = -1;
        	}
	        SafeReleaseResource(hostState, rControlTemplate, hostID, resFile);
	    }
       	else {
			listSubP->hostType = 0;
			listSubP->hostID = 0L;
		}
	}
	else {
		nameP = getNameRec(workIndex, rControlTemplate);
		if (nameP) {
			count = nameP->count;
			nameSubP = (nameSubPtr) *nameP->itemHndl;
        	for (i = 0; i < count; i++) {
				MoonCursor();
				if (nameSubP[i].nFlag & 0x4000) {
					count++;
					continue;
				}
				hostID = nameSubP[i].id;
				hostData = SafeLoadResource2(&hostState, rControlTemplate, hostID, resFile);
				if (!toolerror()) {
					ctl.dummy = deref(hostData);
					if (ctl.BcPtr->ctlTemplate.procRef == listControl && ctl.LcPtr->listRef == resID) {
						listMemSize = ctl.LcPtr->listMemSize;
						listSize = ctl.LcPtr->listSize;
						listSubP->hostType = rControlTemplate;
						listSubP->hostID = hostID;
						retVal = -1;
                    	break;
                	}
                	SafeReleaseResource(hostState, rControlTemplate, hostID, resFile);
				}
			}
		}
	}
	if (retVal && (!listMemSize || !listSize))
		retVal = 0;

	*lMemSizeP = listMemSize;
	*lCountP = listSize;

    return retVal;
}

/*--------------------------------------
	SafeLoadResource2 (LoadResource2 in a bubble-bag)

	Marc Wolfgram,  1/ 7/92 23:01:54
*/
Handle SafeLoadResource2(word *state, word resType, long resID, word resFile)
{
word curFile, curDepth, attr, err;
Handle retVal;



   	retVal = 0L;

    curFile = GetCurResourceFile();
    curDepth = SetResourceFileDepth(1);
    SetCurResourceFile(resFile ? resFile : workList[workIndex].resFileID);

    attr = GetResourceAttr(resType, resID);
    if (err = toolerror()) {
    	if (resID > 0x07feffffL) {
        	err = SetResourceFileDepth(2);	/* err word is garbage here */
            attr = GetResourceAttr(resType, resID);
            if (err = toolerror()) {
    			curDepth = SetResourceFileDepth(curDepth);
    			SetCurResourceFile(curFile);
    			SetToolError(err);
            	return retVal;
	     	}
     	}
        else {
    		curDepth = SetResourceFileDepth(curDepth);
    		SetCurResourceFile(curFile);
    		SetToolError(err);
            return retVal;
    	}
    }
    SetResourceAttr(0, resType, resID);
    retVal = LoadResource2(0, state, resType, resID);
    err = toolerror();                  	/* err word is really used here */
    SetResourceAttr(attr, resType, resID);

    curDepth = SetResourceFileDepth(curDepth);
    SetCurResourceFile(curFile);

    SetToolError(err);
    return retVal;
}

/*--------------------------------------
	SafeReleaseResource (ReleaseResource in a bubble-bag too)

	Marc Wolfgram,  1/ 7/92 23:28:09
*/
void SafeReleaseResource(word state, word resType, long resID, word resFile)
{
word curFile, curDepth, attr, err;

	err = 0;
	if (state == 0xffff) {

    	curFile = GetCurResourceFile();
    	curDepth = SetResourceFileDepth(2);
    	SetCurResourceFile(resFile ? resFile : workList[workIndex].resFileID);

    	ReleaseResource(-1, resType, resID);
		err = toolerror();

    	curDepth = SetResourceFileDepth(curDepth);
    	SetCurResourceFile(curFile);

    }
    else if ((state & 0x8000) == 0)
    	HUnlock(LoadResource(resType, resID));

    SetToolError(err);
    return;
}

/*--------------------------------------
	setLink - used by remExtendLinkHand (calls.c) and addChildRef

	Marc Wolfgram,  1/11/92 16:48:04
*/
word setLink(resLinkRecHndl lHndl, word childType, long childID, word hostType, long hostID)
{
word i, retVal;
resLinkRecPtr lPtr;
nameSubPtr  nameS;

	retVal = 0;

	if (childID) {
    	HUnlock(lHndl);
    	SetHandleSize(GetHandleSize(lHndl) + sizeof (resLink), lHndl);
    	if ((retVal = toolerror()) == 0) {

    		(Pointer) lPtr = deref((Handle) lHndl);
			i = lPtr->count;
        	lPtr->count++;
        	lPtr->ref[i].hostType = hostType;
        	lPtr->ref[i].hostID = hostID;
        	lPtr->ref[i].resType = childType;
        	lPtr->ref[i].resID = childID;

			if (lPtr->resFileID == workList[workIndex].resFileID) {
				nameS = getNameSubRec(workIndex, hostType, hostID);
    			if (nameS)
        			lPtr->ref[i].hostHitTick = nameS->hitTick;
				nameS = getNameSubRec(workIndex, childType, childID);
    			if (nameS) {
    				nameS->hostType = hostType;
    				nameS->hostID = hostID;
        			lPtr->ref[i].resHitTick = nameS->hitTick;
            	}

            }
        }
    }
    HUnlock(lHndl);

    return SetToolError(retVal);
}

/*--------------------------------------
	setHost - a new and improved version of setHostRef

	Marc Wolfgram,  1/11/92  2:27:41
*/
word setHost(word childType, long childID, word parsedType, long parsedID, word hostType, long hostID)
{
nameSubPtr  nameS;

    if (childType == parsedType) {
    	if (parsedID) {
			nameS = getNameSubRec(workIndex, parsedType, parsedID);
    		if (nameS) {
    			nameS->hostType = hostType;
    			nameS->hostID = hostID;
    		}
			if (childID == parsedID)
				return 1;
    	}
    }
	return 0;
}

/*--------------------------------------
	setHost2 - setHost extended to swap child ID references

	Marc Wolfgram,  3/16/92  0:57:10
*/
word setHost2(word childType, long childID, long newID, word parsedType, long *parsedID, word hostType, long hostID)
{
nameSubPtr  nameS;

    if (childType == parsedType) {
    	if (*parsedID) {
			nameS = getNameSubRec(workIndex, parsedType, *parsedID);
    		if (nameS) {
    			nameS->hostType = hostType;
    			nameS->hostID = hostID;
    		}
			if (childID == *parsedID) {
                *parsedID = newID;
                return 1;
        	}
        }
    }
	return 0;
}

/*--------------------------------------
    remLoadSpecial

    Marc Wolfgram,  4/27/91 12:23:45
    Add ItemStruct 10/10/91 20:14:40
    Went gonzo     10/15/91 21:49:11
*/
Handle remLoadSpecial(Word resType, LongWord resID)
{
word                i, ctlPCnt, ctlMore;
long                *LongPtr;
Handle               retHndl;
control              ctl;
MenuBarTemplate     *MBarPtr;
MenuTemplate        *MenuPtr;
MenuItemTemplate    *ItemPtr;
itemStruct          *StructPtr;
WinTemplate         *WinPtr;

    retHndl = LoadResource(resType, resID);
    DetachResource(resType, resID);
    HLock(retHndl);

    switch (resType) {
    case rControlList:
        LongPtr = (long *) *retHndl;
        for (i = 0; LongPtr[i] != 0L; i++)
            (Handle) LongPtr[i] = remLoadSpecial(rControlTemplate, LongPtr[i]);
        break;

    case rControlTemplate:
        ctl.dummy = (Pointer) *retHndl;
        ctlPCnt = ctl.BcPtr->ctlTemplate.pCount;
        ctlMore = ctl.BcPtr->ctlTemplate.moreFlags;
        switch (ctl.BcPtr->ctlTemplate.procRef) {
        case simpleButtonControl:
            ctlMore &= 0xfff0;
            if (ctl.BcPtr->titleRef) {
                ctlMore |= 0x0001;
                (Handle) ctl.BcPtr->titleRef = remLoadSpecial(rPString, ctl.BcPtr->titleRef);
            }
            if (ctlPCnt > 7 && ctl.BcPtr->colorTableRef) {
                ctlMore |= 0x0004;
                (Handle) ctl.BcPtr->colorTableRef = remLoadSpecial(rCtlColorTbl, ctl.BcPtr->colorTableRef);
            }
            break;

        case checkControl:
        case radioControl:
            ctlMore &= 0xfff0;
            if (ctl.CBcPtr->titleRef) {
                ctlMore |= 0x0001;
                (Handle) ctl.CBcPtr->titleRef = remLoadSpecial(rPString, ctl.CBcPtr->titleRef);
            }
            if (ctlPCnt > 8 && ctl.CBcPtr->colorTableRef) {
                ctlMore |= 0x0004;
                (Handle) ctl.CBcPtr->colorTableRef = remLoadSpecial(rCtlColorTbl, ctl.CBcPtr->colorTableRef);
            }
            break;

        case scrollBarControl:
            ctlMore &= 0xfff3;
            if (ctlPCnt > 9 && ctl.SBcPtr->colorTableRef) {
                ctlMore |= 0x0004;
                (Handle) ctl.SBcPtr->colorTableRef = remLoadSpecial(rCtlColorTbl, ctl.SBcPtr->colorTableRef);
            }
            break;

        case growControl:
            ctlMore &= 0xfff3;
            if (ctlPCnt > 6 && ctl.GcPtr->colorTableRef) {
                ctlMore |= 0x0004;
                (Handle) ctl.GcPtr->colorTableRef = remLoadSpecial(rCtlColorTbl, ctl.GcPtr->colorTableRef);
            }
            break;

        case statTextControl:
            ctlMore &= 0xfffc;
            if (ctl.BcPtr->titleRef) {
                ctlMore |= 0x0001;
                (Handle) ctl.BcPtr->titleRef = remLoadSpecial(rTextForLETextBox2, ctl.BcPtr->titleRef);
            }
            break;

        case editLineControl:
            ctlMore &= 0xfffc;
            if (ctl.LEcPtr->defaultRef) {
                ctlMore |= 0x0001;
                (Handle) ctl.LEcPtr->defaultRef = remLoadSpecial(rPString, ctl.LEcPtr->defaultRef);
            }
            break;

        case editTextControl:
            ctlMore &= 0xfff0;
            if (ctlPCnt > 12 & ctl.TEcPtr->styleRef) {
                ctlMore |= 0x0001;
                (Handle) ctl.TEcPtr->styleRef = remLoadSpecial(rStyleBlock, (Long) ctl.TEcPtr->styleRef);
            }
            if (ctlPCnt > 14 && ctl.TEcPtr->textRef) {
                ctl.TEcPtr->textDescriptor &= 0xffe7;
                ctl.TEcPtr->textDescriptor |= 0x0008;
                i = ctl.TEcPtr->textDescriptor & 0x0007;
                (Handle) ctl.TEcPtr->textRef = remLoadSpecial(TEType[i], ctl.TEcPtr->textRef);
            }
            if (ctlPCnt > 20 && ctl.TEcPtr->colorRef) {
                ctlMore |= 0x0004;
                (Handle) ctl.TEcPtr->colorRef = remLoadSpecial(rCtlColorTbl, ctl.TEcPtr->colorRef);
            }
            break;

        case popUpControl:
            ctlMore &= 0xffe0;
            ctlMore |= 0x0001;
            (Handle) ctl.PMcPtr->menuRef = remLoadSpecial(rMenu, ctl.PMcPtr->menuRef);
            if (ctlPCnt > 9 && ctl.PMcPtr->colorTableRef) {
                ctlMore |= 0x0008;
                (Handle) ctl.PMcPtr->colorTableRef = remLoadSpecial(rCtlColorTbl, ctl.PMcPtr->colorTableRef);
            }
            break;

        case listControl:
            ctlMore &= 0xfff0;
            if (ctl.LcPtr->listRef) { /* note that listRef can be null */
                ctlMore |= 0x0001;
                (Handle) ctl.LcPtr->listRef = remLoadSpecial(rListRef, ctl.LcPtr->listRef);
            }
            if (ctlPCnt > 14 && ctl.LcPtr->colorTableRef) {
                ctlMore |= 0x0004;
                (Handle) ctl.LcPtr->colorTableRef = remLoadSpecial(rCtlColorTbl, ctl.LcPtr->colorTableRef);
            }
            break;

        case pictureControl:
            ctlMore &= 0xfff0;
            if (ctl.PcPtr->pictureRef) {
                ctlMore |= 0x0001;
                (Handle) ctl.PcPtr->pictureRef = remLoadSpecial(rPicture, ctl.PcPtr->pictureRef);
            }
            break;

        case iconButtonControl:
        case 0x07ff0001:
            ctlMore &= 0xffc0;
            if (ctl.IcPtr->iconRef) {
                ctlMore |= 0x0010;
                (Handle) ctl.IcPtr->iconRef = remLoadSpecial(rIcon, ctl.IcPtr->iconRef);
            }
            if (ctlPCnt > 7 && ctl.IcPtr->titleRef) {
                ctlMore |= 0x0001;
                (Handle) ctl.IcPtr->titleRef = remLoadSpecial(rPString, ctl.IcPtr->titleRef);
            }
            if (ctlPCnt > 8 && ctl.IcPtr->colorTableRef) {
                ctlMore |= 0x0004;
                (Handle) ctl.IcPtr->colorTableRef = remLoadSpecial(rCtlColorTbl, ctl.IcPtr->colorTableRef);
            }
            break;

        case thermometerControl:
            ctlMore &= 0xfffc;
            if (ctlPCnt > 8 && ctl.TcPtr->colorTableRef) {
                ctlMore |= 0x0001;
                (Handle) ctl.TcPtr->colorTableRef = remLoadSpecial(rCtlColorTbl, ctl.TcPtr->colorTableRef);
            }
            break;

		default:
			break;
        }
        ctl.BcPtr->ctlTemplate.moreFlags = ctlMore;
        break;


    case rMenuBar:
        MBarPtr = (MenuBarTemplate *) *retHndl;
        MBarPtr->menuFlag &= 0x3fff;
        MBarPtr->menuFlag |= 0x4000;
        for (i = 0; MBarPtr->menuRefArray[i] != 0L; i++)
            (Handle) MBarPtr->menuRefArray[i] = remLoadSpecial(rMenu, MBarPtr->menuRefArray[i]);
        break;

    case rMenu:
        MenuPtr = (MenuTemplate *) *retHndl;
        MenuPtr->menuFlag &= 0x0fff;
        MenuPtr->menuFlag |= 0x5000;
        (Handle) MenuPtr->menuTitleRef = remLoadSpecial(rPString, MenuPtr->menuTitleRef);
        for (i = 0; MenuPtr->itemRefArray[i] != 0L; i++)
            (Handle) MenuPtr->itemRefArray[i] = remLoadSpecial(rMenuItem, MenuPtr->itemRefArray[i]);
        break;

    case rMenuItem:
        ItemPtr = (MenuItemTemplate *) *retHndl;
        ItemPtr->itemFlag &= 0x3fff;
        ItemPtr->itemFlag |= 0x4000;
        if (ItemPtr->itemFlag & 0x0400) {
            ItemPtr->itemFlag &= 0xfcff;
            ItemPtr->itemFlag |= 0x0100;
            (Handle) ItemPtr->itemTitleRef = remLoadSpecial(rItemStruct, ItemPtr->itemTitleRef);
        }
        else
            (Handle) ItemPtr->itemTitleRef = remLoadSpecial(rPString, ItemPtr->itemTitleRef);
        break;

    case rWindParam1:
        WinPtr = (WinTemplate *) *retHndl;
        WinPtr->plInDesc &= 0xf0ff;
        if (WinPtr->plTitle) {
            WinPtr->plInDesc |= 0x0100;
            (Handle) WinPtr->plTitle = remLoadSpecial(rPString, WinPtr->plTitle);
        }
        if (WinPtr->plColor) {
            WinPtr->plInDesc |= 0x0400;
            (Handle) WinPtr->plColor = remLoadSpecial(rWindColor, WinPtr->plColor);
        }
        if (WinPtr->plControlList) {
            if ((WinPtr->plInDesc & 0x00ff) == 2) {
                WinPtr->plInDesc &= 0xf500;
                WinPtr->plInDesc |= 0x0001; /* single handle to control */
                (Handle) WinPtr->plControlList = remLoadSpecial(rControlTemplate, WinPtr->plControlList);
            }
            else if ((WinPtr->plInDesc & 0x00ff) == 9) {
                WinPtr->plInDesc &= 0xf500;
                WinPtr->plInDesc |= 0x0007; /* handle to control list handle */
                (Handle) WinPtr->plControlList = remLoadSpecial(rControlList, WinPtr->plControlList);
            }
        }
        break;

    case rItemStruct:
        StructPtr = (itemStruct *) *retHndl;
        (Handle) StructPtr->itemTitleRef = remLoadSpecial(rPString, StructPtr->itemTitleRef);
        if (StructPtr->itemFlag2 & 0x8000) {
            StructPtr->itemFlag2 &= 0xfff3;
            StructPtr->itemFlag2 |= 0x0001;
            (Handle) StructPtr->itemIconRef = remLoadSpecial(rIcon, StructPtr->itemIconRef);
        }
        break;
    }
    HUnlock(retHndl);

    return retHndl;
}

/*--------------------------------------
    remTwiddleSpecial

    Marc Wolfgram,  4/27/91 12:23:45
                    4/29/91 19:27:12   was remLockMenu, added flag
*/
word remTwiddleSpecial(Word resType, Handle partHndl, word flag)
{
word                 i, ctlPCnt, ctlMore;
long                *LongPtr;
control              ctl;
MenuBarTemplate     *MBarPtr;
MenuTemplate        *MenuPtr;
MenuItemTemplate    *ItemPtr;
itemStruct          *StructPtr;
WinTemplate         *WinPtr;

    HLock(partHndl);

    switch (resType) {
    case rControlList:
        LongPtr = (long *) *partHndl;
        for (i = 0; LongPtr[i] != 0L; i++)
            remTwiddleSpecial(rControlTemplate, (Handle) LongPtr[i], flag);
        break;

    case rControlTemplate:
        ctl.dummy = (Pointer) *partHndl;
        ctlPCnt = ctl.BcPtr->ctlTemplate.pCount;
        ctlMore = ctl.BcPtr->ctlTemplate.moreFlags;
        switch (ctl.BcPtr->ctlTemplate.procRef) {
        case simpleButtonControl:
            if (ctl.BcPtr->titleRef)
                remTwiddleSpecial(rPString, (Handle) ctl.BcPtr->titleRef, flag);
            if (ctlPCnt > 7 && ctl.BcPtr->colorTableRef)
                remTwiddleSpecial(rCtlColorTbl, (Handle) ctl.BcPtr->colorTableRef, flag);
            break;

        case checkControl:
        case radioControl:
            if (ctl.CBcPtr->titleRef)
                remTwiddleSpecial(rPString, (Handle) ctl.CBcPtr->titleRef, flag);
            if (ctlPCnt > 8 && ctl.CBcPtr->colorTableRef)
                remTwiddleSpecial(rCtlColorTbl, (Handle) ctl.CBcPtr->colorTableRef, flag);
            break;

        case scrollBarControl:
            if (ctlPCnt > 9 && ctl.SBcPtr->colorTableRef)
                remTwiddleSpecial(rCtlColorTbl, (Handle) ctl.SBcPtr->colorTableRef, flag);
            break;

        case growControl:
            if (ctlPCnt > 6 && ctl.GcPtr->colorTableRef)
                remTwiddleSpecial(rCtlColorTbl, (Handle) ctl.GcPtr->colorTableRef, flag);
            break;

        case statTextControl:
            if (ctl.BcPtr->titleRef)
                remTwiddleSpecial(rTextForLETextBox2, (Handle) ctl.BcPtr->titleRef, flag);
            break;

        case editLineControl:
            if (ctl.LEcPtr->defaultRef)
                remTwiddleSpecial(rPString, (Handle) ctl.LEcPtr->defaultRef, flag);
            break;

        case editTextControl:
            if (ctlPCnt > 12 & ctl.TEcPtr->styleRef)
                remTwiddleSpecial(rStyleBlock, (Handle) ctl.TEcPtr->styleRef, flag);
            if (ctlPCnt > 14 && ctl.TEcPtr->textRef) {     /* the puppy has text */
                i = ctl.TEcPtr->textDescriptor & 0x0007;
                remTwiddleSpecial(TEType[i], (Handle) ctl.TEcPtr->textRef, flag);
            }
            if (ctlPCnt > 20 && ctl.TEcPtr->colorRef)
                remTwiddleSpecial(rCtlColorTbl, (Handle) ctl.TEcPtr->colorRef, flag);
            break;

        case popUpControl:
            remTwiddleSpecial(rMenu, (Handle) ctl.PMcPtr->menuRef, flag);
            if (ctlPCnt > 9 && ctl.PMcPtr->colorTableRef)
                remTwiddleSpecial(rCtlColorTbl, (Handle) ctl.PMcPtr->colorTableRef, flag);
            break;

        case listControl:
            if (ctl.LcPtr->listRef) /* note that listRef can be null */
                remTwiddleSpecial(rListRef, (Handle) ctl.LcPtr->listRef, flag);
            if (ctlPCnt > 14 && ctl.LcPtr->colorTableRef)
                remTwiddleSpecial(rCtlColorTbl, (Handle) ctl.LcPtr->colorTableRef, flag);
            break;

        case pictureControl:
            if (ctl.PcPtr->pictureRef)
                remTwiddleSpecial(rPicture, (Handle) ctl.PcPtr->pictureRef, flag);
            break;

        case iconButtonControl:
        case 0x07ff0001:
            if (ctl.IcPtr->iconRef)
                remTwiddleSpecial(rIcon, (Handle) ctl.IcPtr->iconRef, flag);
            if (ctlPCnt > 7 && ctl.IcPtr->titleRef)
                remTwiddleSpecial(rPString, (Handle) ctl.IcPtr->titleRef, flag);
            if (ctlPCnt > 8 && ctl.IcPtr->colorTableRef)
                remTwiddleSpecial(rCtlColorTbl, (Handle) ctl.IcPtr->colorTableRef, flag);
            break;

        case thermometerControl:
            if (ctlPCnt > 8 && ctl.TcPtr->colorTableRef)
                remTwiddleSpecial(rCtlColorTbl, (Handle) ctl.TcPtr->colorTableRef, flag);
            break;

		default:
			break;
        }
        break;

    case rMenuBar:
        MBarPtr = (MenuBarTemplate *) *partHndl;
        for (i = 0; MBarPtr->menuRefArray[i] != 0L; i++)
            remTwiddleSpecial(rMenu, (Handle) MBarPtr->menuRefArray[i], flag);
        break;

    case rMenuItem:
        ItemPtr = (MenuItemTemplate *) *partHndl;
        if (ItemPtr->itemFlag & 0x0400)
            remTwiddleSpecial(rItemStruct, (Handle) ItemPtr->itemTitleRef, flag);
        else
            remTwiddleSpecial(rPString, (Handle) ItemPtr->itemTitleRef, flag);
        break;

    case rMenu:
        MenuPtr = (MenuTemplate *) *partHndl;
        remTwiddleSpecial(rPString, (Handle) MenuPtr->menuTitleRef, flag);
        for (i = 0; MenuPtr->itemRefArray[i] != 0L; i++)
            remTwiddleSpecial(rMenuItem, (Handle) MenuPtr->itemRefArray[i], flag);
        break;

    case rWindParam1:
        WinPtr = (WinTemplate *) *partHndl;
        if (WinPtr->plTitle)
            remTwiddleSpecial(rPString, (Handle) WinPtr->plTitle, flag);
        if (WinPtr->plColor)
            remTwiddleSpecial(rWindColor, (Handle) WinPtr->plColor, flag);
        if (WinPtr->plControlList) {
            if ((WinPtr->plInDesc & 0x00ff) == 1)
                remTwiddleSpecial(rControlTemplate, (Handle) WinPtr->plControlList, flag);
            else if ((WinPtr->plInDesc & 0x00ff) == 7)
                remTwiddleSpecial(rControlList, (Handle) WinPtr->plControlList, flag);
        }
        break;

    case  rItemStruct:
        StructPtr = (itemStruct *) *partHndl;
        remTwiddleSpecial(rPString, (Handle) StructPtr->itemTitleRef, flag);
        if (StructPtr->itemFlag2 & 0x8000)
            remTwiddleSpecial(rIcon, (Handle) StructPtr->itemIconRef, flag);
        break;

    }
    if (flag)
        HUnlock(partHndl);
    if (flag == 2)
        DisposeHandle(partHndl);

    return 0;
}

/*--------------------------------------
    addChildRef

    Marc Wolfgram, 11/18/91 20:50:27
*/
word addChildRef(resLinkRecHndl linkH, word hostType, long hostID)
{
word i, ctlPCnt, ctlMore, offset, count, size, flag, hostState, retVal;
Handle				hostData;
Pointer             hostPtr;
long                *LongPtr;
control              ctl;
wkPtr				 srcPtr, tmpPtr;
MenuBarTemplate     *MBarPtr;
MenuTemplate        *MenuPtr;
MenuItemTemplate    *ItemPtr;
itemStruct          *StructPtr;
WinTemplate         *WinPtr;
resLinkRecHndl      ownerH;

    hostData = SafeLoadResource2(&hostState, hostType, hostID, 0);
    if (retVal = toolerror())
        return retVal;
    hostPtr = deref(hostData);

    switch (hostType) {
    case rControlList:
        LongPtr = (long *) hostPtr;
        for (i = 0; LongPtr[i] != 0L && !retVal; i++)
			retVal = setLink(linkH, rControlTemplate, LongPtr[i], rControlList, hostID);
        break;

    case rControlTemplate:
        ctl.dummy = hostPtr;
        ctlPCnt = ctl.BcPtr->ctlTemplate.pCount;
        ctlMore = ctl.BcPtr->ctlTemplate.moreFlags;

        switch (ctl.BcPtr->ctlTemplate.procRef) {
        case simpleButtonControl:
            retVal = setLink(linkH, rPString, (long) ctl.BcPtr->titleRef, rControlTemplate, hostID);
            if (ctlPCnt > 7 && !retVal)
                retVal = setLink(linkH, rCtlColorTbl, (long) ctl.BcPtr->colorTableRef, rControlTemplate, hostID);
            break;

        case checkControl:
        case radioControl:
            retVal = setLink(linkH, rPString, ctl.CBcPtr->titleRef, rControlTemplate, hostID);
            if (ctlPCnt > 8 && !retVal)
                retVal = setLink(linkH, rCtlColorTbl, (long) ctl.CBcPtr->colorTableRef, rControlTemplate, hostID);
            break;

        case scrollBarControl:
            if (ctlPCnt > 9)
                retVal = setLink(linkH, rCtlColorTbl, (long) ctl.SBcPtr->colorTableRef, rControlTemplate, hostID);
            break;

        case growControl:
            if (ctlPCnt > 6)
                retVal = setLink(linkH, rCtlColorTbl, (long) ctl.GcPtr->colorTableRef, rControlTemplate, hostID);
            break;

        case statTextControl:
          	retVal = setLink(linkH, rTextForLETextBox2, (long) ctl.BcPtr->titleRef, rControlTemplate, hostID);
            break;

        case editLineControl:
          	retVal = setLink(linkH, rPString, (long) ctl.LEcPtr->defaultRef, rControlTemplate, hostID);
            break;

        case editTextControl:
            if (ctlPCnt > 12)
                retVal = setLink(linkH, rStyleBlock, (long) ctl.TEcPtr->styleRef, rControlTemplate, hostID);
            if (ctlPCnt > 14 && !retVal)
                i = ctl.TEcPtr->textDescriptor & 0x0007;
                retVal = setLink(linkH, TEType[i], (long) ctl.TEcPtr->textRef, rControlTemplate, hostID);
            if (ctlPCnt > 20 && !retVal)
				retVal = setLink(linkH, rCtlColorTbl, (long) ctl.TEcPtr->colorRef, rControlTemplate, hostID);
            break;

        case popUpControl:
            retVal = setLink(linkH, rMenu, (long) ctl.PMcPtr->menuRef, rControlTemplate, hostID);
            if (ctlPCnt > 9 && !retVal)
                retVal = setLink(linkH, rCtlColorTbl, (long) ctl.PMcPtr->colorTableRef, rControlTemplate, hostID);
            break;

        case listControl:
         	retVal = setLink(linkH, rListRef, (long) ctl.LcPtr->listRef, rControlTemplate, hostID);
            if (ctlPCnt > 14 && !retVal)
                retVal = setLink(linkH, rCtlColorTbl, (long) ctl.LcPtr->colorTableRef, rControlTemplate, hostID);
            break;

        case pictureControl:
            retVal = setLink(linkH, rPicture, (long) ctl.PcPtr->pictureRef, rControlTemplate, hostID);
            break;

        case iconButtonControl:
        case 0x07ff0001:
            retVal = setLink(linkH, rIcon, (long) ctl.IcPtr->iconRef, rControlTemplate, hostID);
            if (ctlPCnt > 7 && !retVal)
                retVal = setLink(linkH, rPString, (long) ctl.IcPtr->titleRef, rControlTemplate, hostID);
            if (ctlPCnt > 8 && !retVal)
                retVal = setLink(linkH, rCtlColorTbl, (long) ctl.IcPtr->colorTableRef, rControlTemplate, hostID);
            break;

        case thermometerControl:
            if (ctlPCnt > 8)
                retVal = setLink(linkH, rCtlColorTbl, (long) ctl.TcPtr->colorTableRef, rControlTemplate, hostID);
            break;

		default:
			break;
        }
        break;

    case rMenuBar:
        MBarPtr = (MenuBarTemplate *) hostPtr;
        for (i = 0; MBarPtr->menuRefArray[i] != 0L && !retVal; i++)
            retVal = setLink(linkH, rMenu, (long) MBarPtr->menuRefArray[i], rMenuBar, hostID);
        break;

    case rMenu:
        MenuPtr = (MenuTemplate *) hostPtr;
        retVal = setLink(linkH, rPString, (long) MenuPtr->menuTitleRef, rMenu, hostID);
        for (i = 0; MenuPtr->itemRefArray[i] != 0L && !retVal; i++)
            retVal = setLink(linkH, rMenuItem, (long) MenuPtr->itemRefArray[i], rMenu, hostID);
        break;

    case rMenuItem:
        ItemPtr = (MenuItemTemplate *) hostPtr;
        if (ItemPtr->itemFlag & 0x0400)
            retVal = setLink(linkH, rItemStruct, (long) ItemPtr->itemTitleRef, rMenuItem, hostID);
        else
            retVal = setLink(linkH, rPString, (long) ItemPtr->itemTitleRef, rMenuItem, hostID);
        break;

    case rWindParam1:
        WinPtr = (WinTemplate *) hostPtr;
        retVal = setLink(linkH, rPString, (long) WinPtr->plTitle, rWindParam1, hostID);
        if (!retVal)
        	retVal = setLink(linkH, rWindColor, (long) WinPtr->plColor, rWindParam1, hostID);
		if ((WinPtr->plInDesc & 0x00ff) == 2 && !retVal)
        	retVal = setLink(linkH, rControlTemplate, (long) WinPtr->plControlList, rWindParam1, hostID);
        else if ((WinPtr->plInDesc & 0x00ff) == 9 && !retVal)
			retVal = setLink(linkH, rControlList, (long) WinPtr->plControlList, rWindParam1, hostID);
        break;

    case  rListRef:
		if (getListCtlData(&size, &count, hostID, 0)) {
	    	tmpPtr.Ptr = (char *) hostPtr;
	        for (i = 0; i < count && !retVal; i++, tmpPtr.Ptr += size)
            	retVal = setLink(linkH, rPString, *tmpPtr.lPtr, rListRef, hostID);
        }
        break;

    case  rItemStruct:
        StructPtr = (itemStruct *) hostPtr;
        retVal = setLink(linkH, rPString, (long) StructPtr->itemTitleRef, rItemStruct, hostID);
        if (StructPtr->itemFlag2 & 0x8000 && !retVal)
            retVal = setLink(linkH, rIcon, (long) StructPtr->itemIconRef, rItemStruct, hostID);
        break;

    case rBundle:
		srcPtr.Ptr = hostPtr;
		srcPtr.Ptr += 2;
		offset = *srcPtr.wPtr;   /* first we deal with the bundle header */
		srcPtr.Ptr += 2;
		retVal = setLink(linkH, rIcon, *srcPtr.lPtr, rBundle, hostID);
		srcPtr.Ptr = hostPtr + offset;
		count = *srcPtr.wPtr;
    	srcPtr.Ptr += 2;            /* since we now have our header info */
		for (i = 0; i < count && !retVal; i++) {
			size = *srcPtr.wPtr;
			tmpPtr.Ptr = srcPtr.Ptr + 4;
			flag = *tmpPtr.wPtr;
			if (flag > 1 && !retVal) {
				tmpPtr.Ptr = srcPtr.Ptr + 8;
				retVal = setLink(linkH, rFinderPath, *tmpPtr.lPtr, rBundle, hostID);
			}
			if (flag > 2 && !retVal) {
				tmpPtr.Ptr = srcPtr.Ptr + 16;
				retVal = setLink(linkH, rIcon, *tmpPtr.lPtr, rBundle, hostID);
			}
			if (flag > 3 && !retVal) {
				tmpPtr.Ptr = srcPtr.Ptr + 24;
				retVal = setLink(linkH, rIcon, *tmpPtr.lPtr, rBundle, hostID);
			}
			(long) srcPtr.Ptr += size;
		}
		break;

    case rFinderPath:
		srcPtr.Ptr = hostPtr;
		srcPtr.Ptr += 4;
        count = *srcPtr.wPtr;
		srcPtr.Ptr += 2;
        for (i = count; i > 0; i--) {
		    retVal = setLink(linkH, rVersion, *srcPtr.lPtr, rFinderPath, hostID);
            srcPtr.Ptr += 8;
        }
		break;
    }
    SafeReleaseResource(hostState, hostType, hostID, 0);
    return retVal;
}

/*--------------------------------------
    remFindOwner

	Marc Wolfgram & Mark Collins,  1/ 4/92 22:47:46
*/
resLinkRecHndl remFindOwner(word resType, long resID)
{
word i, j, k, m, ctlPCnt, ctlMore, offset, count, size, flag, match, hostType, hostState;
wkPtr				 srcPtr, tmpPtr;
long                *LongPtr, hostID;
Handle				 hostData;
Pointer				 hostPtr;
resLinkRecHndl       retHndl;
control              ctl;
MenuBarTemplate     *MBarPtr;
MenuTemplate        *MenuPtr;
MenuItemTemplate    *ItemPtr;
itemStruct          *StructPtr;
WinTemplate         *WinPtr;
namePtr              nameP;
nameSubPtr           nameSubP;


    (Handle) retHndl = NewHandle(24L, fMemID, 0x8018, 0L);
    if (toolerror())
    	return retHndl;

    (**retHndl).count = 0;
    (**retHndl).resFileID = workList[workIndex].resFileID;
    (**retHndl).ref[0].resType = resType;
    (**retHndl).ref[0].resID = resID;
    nameSubP = getNameSubRec(workIndex, resType, resID);
    if (nameSubP->hostType) {
        (**retHndl).count = 1;
        (**retHndl).ref[0].hostType = nameSubP->hostType;
        (**retHndl).ref[0].hostID = nameSubP->hostID;
        (**retHndl).ref[0].resHitTick = nameSubP->hitTick;
        nameSubP = getNameSubRec(workIndex, nameSubP->hostType, nameSubP->hostID);
        (**retHndl).ref[0].hostHitTick = nameSubP->hitTick;
        return retHndl;
    }
    (**retHndl).ref[0].hostType = 0;
    (**retHndl).ref[0].hostID = 0L;
    match = 0;
    for (i = 0; MasterRace[i].rType && !match; i++) {
		MoonCursor();
        if (MasterRace[i].rType == resType) {	/* found the type... */
        	if (MasterRace[i].dType < 2)        /* no hosts for this type */
        		break;

	        for (j = 0; MasterRace[i].hType[j] && !match; j++) { /* found it, now work hard */
				MoonCursor();
                hostType = MasterRace[i].hType[j];
	            nameP = getNameRec(workIndex, hostType);
	            if (!nameP)
	            	continue;
	            count = nameP->count;
	            nameSubP = (nameSubPtr) *nameP->itemHndl;
	            for (k = 0; k < count && !match; k++) {
	            	if (nameSubP[k].nFlag & 0x4000) {
		            	count++;
			            continue;
			        }
					MoonCursor();
	                hostID = nameSubP[k].id;
	                hostData = SafeLoadResource2(&hostState, hostType, hostID, 0);
                    hostPtr = deref(hostData);
                    if (toolerror()) {
                    	SafeReleaseResource(hostState, hostType, hostID, 0);
                        continue;
                    }

	                switch(hostType) {
	                case rControlList:
	                    LongPtr = (long *) hostPtr;
	                    for (m = 0; LongPtr[m] != 0L; m++)
							match |= setHost(resType, resID, rControlTemplate, LongPtr[m], rControlList, hostID);
	                    break;

	                case rControlTemplate:
	                    ctl.dummy = hostPtr;
	                    ctlPCnt = ctl.BcPtr->ctlTemplate.pCount;
	                    ctlMore = ctl.BcPtr->ctlTemplate.moreFlags;
	                    switch (ctl.BcPtr->ctlTemplate.procRef) {
	                    case simpleButtonControl:
							match |= setHost(resType, resID, rPString, ctl.BcPtr->titleRef, rControlTemplate, hostID);
	                        if (ctlPCnt > 7)
								match |= setHost(resType, resID, rCtlColorTbl, ctl.BcPtr->colorTableRef, rControlTemplate, hostID);
                            break;

	                    case checkControl:
	                    case radioControl:
							match |= setHost(resType, resID, rPString, ctl.CBcPtr->titleRef, rControlTemplate, hostID);
	                        if (ctlPCnt > 8)
								match |= setHost(resType, resID, rCtlColorTbl, ctl.CBcPtr->colorTableRef, rControlTemplate, hostID);
	                        break;

	                    case scrollBarControl:
	                        if (ctlPCnt > 9)
								match |= setHost(resType, resID, rCtlColorTbl, ctl.SBcPtr->colorTableRef, rControlTemplate, hostID);
	                        break;

	                    case growControl:
	                        if (ctlPCnt > 6)
								match |= setHost(resType, resID, rCtlColorTbl, ctl.GcPtr->colorTableRef, rControlTemplate, hostID);
	                        break;

	                    case statTextControl:
							match |= setHost(resType, resID, rTextForLETextBox2, ctl.BcPtr->titleRef, rControlTemplate, hostID);
	                        break;

	                    case editLineControl:
							match |= setHost(resType, resID, rPString, ctl.LEcPtr->defaultRef, rControlTemplate, hostID);
	                        break;

	                    case editTextControl:
	                        if (ctlPCnt > 12)
								match |= setHost(resType, resID, rStyleBlock, ctl.TEcPtr->styleRef, rControlTemplate, hostID);
	                        if (ctlPCnt > 14) {
	                            m = ctl.TEcPtr->textDescriptor & 0x0007;
								match |= setHost(resType, resID, TEType[m], ctl.TEcPtr->textRef, rControlTemplate, hostID);
	                        }
	                        if (ctlPCnt > 20)
								match |= setHost(resType, resID, rCtlColorTbl, ctl.TEcPtr->colorRef, rControlTemplate, hostID);
	                        break;

	                    case popUpControl:
							match |= setHost(resType, resID, rMenu, ctl.PMcPtr->menuRef, rControlTemplate, hostID);
	                        if (ctlPCnt > 9)
								match |= setHost(resType, resID, rCtlColorTbl, ctl.PMcPtr->colorTableRef, rControlTemplate, hostID);
	                        break;

	                    case listControl:
							match |= setHost(resType, resID, rListRef, ctl.LcPtr->listRef, rControlTemplate, hostID);
	                        if (ctlPCnt > 14)
								match |= setHost(resType, resID, rCtlColorTbl, ctl.PMcPtr->colorTableRef, rControlTemplate, hostID);
	                        break;

	                    case pictureControl:
							match |= setHost(resType, resID, rPicture, ctl.PcPtr->pictureRef, rControlTemplate, hostID);
	                        break;

	                    case iconButtonControl:
	                    case 0x07ff0001:
							match |= setHost(resType, resID, rIcon, ctl.IcPtr->iconRef, rControlTemplate, hostID);
	                        if (ctlPCnt > 7)
								match |= setHost(resType, resID, rPString, ctl.IcPtr->titleRef, rControlTemplate, hostID);
	                        if (ctlPCnt > 8)
								match |= setHost(resType, resID, rCtlColorTbl, ctl.IcPtr->colorTableRef, rControlTemplate, hostID);
	                        break;

	                    case thermometerControl:
	                        if (ctlPCnt > 8)
								match |= setHost(resType, resID, rCtlColorTbl, ctl.TcPtr->colorTableRef, rControlTemplate, hostID);
	                        break;

						default:
							break;
	                    }
	                    break;

	                case rMenuBar:
	                    MBarPtr = (MenuBarTemplate *) hostPtr;
	                    for (m = 0; MBarPtr->menuRefArray[m] != 0L; m++)
							match |= setHost(resType, resID, rMenu, MBarPtr->menuRefArray[m], rMenuBar, hostID);
                        break;

	                case rMenu:
	                    MenuPtr = (MenuTemplate *) hostPtr;
						match |= setHost(resType, resID, rPString, MenuPtr->menuTitleRef, rMenu, hostID);
	                    if (resType == rMenuItem)
	                    	for (m = 0; MenuPtr->itemRefArray[m] != 0L; m++)
								match |= setHost(resType, resID, rMenuItem, MenuPtr->itemRefArray[m], rMenu, hostID);
	                    break;

	                case rMenuItem:
	                	ItemPtr = (MenuItemTemplate *) hostPtr;
	                    if (ItemPtr->itemFlag & 0x0400)
							match |= setHost(resType, resID, rItemStruct, ItemPtr->itemTitleRef, rMenuItem, hostID);
	                    else
							match |= setHost(resType, resID, rPString, ItemPtr->itemTitleRef, rMenuItem, hostID);
	                    break;

	                case rWindParam1:
	                    WinPtr = (WinTemplate *) hostPtr;
						match |= setHost(resType, resID, rPString, WinPtr->plTitle, rWindParam1, hostID);
						match |= setHost(resType, resID, rWindColor, WinPtr->plColor, rWindParam1, hostID);
	                    if ((WinPtr->plInDesc & 0x00ff) == 2)
							match |= setHost(resType, resID, rControlTemplate, WinPtr->plControlList, rWindParam1, hostID);
	                    else if ((WinPtr->plInDesc & 0x00ff) == 9)
							match |= setHost(resType, resID, rControlList, WinPtr->plControlList, rWindParam1, hostID);
	                    break;

					case rListRef:
						if (getListCtlData(&size, &count, hostID, 0)) {
	                    	tmpPtr.Ptr = (char *) hostPtr;
	                        for (m = 0; m < count; m++, tmpPtr.Ptr += size)
								match |= setHost(resType, resID, rPString, *tmpPtr.lPtr, rListRef, hostID);
        				}
						break;

	                case rItemStruct:
	                    StructPtr = (itemStruct *) hostPtr;
						match |= setHost(resType, resID, rPString, StructPtr->itemTitleRef, rItemStruct, hostID);
	                    if (StructPtr->itemFlag2 & 0x8000)
							match |= setHost(resType, resID, rIcon, StructPtr->itemIconRef, rItemStruct, hostID);
	                    break;

					case rBundle:
						srcPtr.Ptr = hostPtr;
						srcPtr.Ptr += 2;
						offset = *srcPtr.wPtr;   /* first we deal with the bundle header */
						srcPtr.Ptr += 2;
						tmpPtr.Ptr = srcPtr.Ptr;
						match |= setHost(resType, resID, rIcon, (long) *tmpPtr.lPtr, rBundle, hostID);
	                    srcPtr.Ptr = hostPtr + offset;

						count = *srcPtr.wPtr;
	    				srcPtr.Ptr += 2;            /* since we now have our header info */
	                    for (m = 0; m < count; m++) {
							size = *srcPtr.wPtr;
							tmpPtr.Ptr = srcPtr.Ptr + 4;
							flag = *srcPtr.wPtr;
	                    	if (flag > 1) {
								tmpPtr.Ptr = srcPtr.Ptr + 8;
								match |= setHost(resType, resID, rFinderPath, *tmpPtr.lPtr, rBundle, hostID);
	                        }
							if (flag > 2) {
								tmpPtr.Ptr = srcPtr.Ptr + 16;
								match |= setHost(resType, resID, rIcon, *tmpPtr.lPtr, rBundle, hostID);
                            }
	                        if (flag > 3) {
								tmpPtr.Ptr = srcPtr.Ptr + 24;
								match |= setHost(resType, resID, rIcon, *tmpPtr.lPtr, rBundle, hostID);
							}
							(long) srcPtr.Ptr += size;
						}
	                    break;

                    case rFinderPath:
		                srcPtr.Ptr = hostPtr;
		                srcPtr.Ptr += 4;
                        count = *srcPtr.wPtr;
                		srcPtr.Ptr += 2;
                        for (m = count; m > 0; m--) {
		                    match |= setHost(resType, resID, rVersion, *srcPtr.lPtr, rFinderPath, hostID);
                            srcPtr.Ptr += 8;
                        }
		                break;

	                }
                    SafeReleaseResource(hostState, hostType, hostID, 0);
                    if (match) {
                        (**retHndl).count = 1;
	                    (**retHndl).ref[0].hostType = hostType;
	                    (**retHndl).ref[0].hostID = hostID;
	                    (**retHndl).ref[0].hostHitTick = nameSubP[k].hitTick;
	                    nameSubP = getNameSubRec(workIndex, resType, resID);
	                    (**retHndl).ref[0].resHitTick = nameSubP->hitTick;
	            	}
	            }
	        }
		}
    }
    return retHndl;
}

/*--------------------------------------
	CopyResource

    Mark Collins  1/12/92  7:19:10
	Copies the blackguard without any outside help!

*/
long CopyResource(word oldFile, word newFile, word resType, long resID)
{
word i, ctlPCnt, ctlMore, offset, count, size, flag, resState, retVal;
Handle				resData, copyData;
Pointer             resPtr;
long                *LongPtr;
long				 resSize, curFile;
control              ctl;
wkPtr				 srcPtr, tmpPtr;
MenuBarTemplate     *MBarPtr;
MenuTemplate        *MenuPtr;
MenuItemTemplate    *ItemPtr;
itemStruct          *StructPtr;
WinTemplate         *WinPtr;
resLinkRecHndl      ownerH;
nameSubPtr		    nameSubP;

    resData = SafeLoadResource2(&resState, resType, resID, oldFile);
    if (toolerror())
        return 0L;

    resSize = GetHandleSize(resData);
    copyData = NewHandle(resSize, fMemID, 0x8008, 0L);
	HandToHand(resData, copyData, resSize);

    SafeReleaseResource(resState, resType, resID, oldFile);
	MoonCursor();

    resPtr = deref(copyData);

    switch (resType) {
    case rControlList:
        LongPtr = (long *) resPtr;
        for (i = 0; LongPtr[i] != 0L; i++)
			LongPtr[i] = CopyResource(oldFile, newFile, rControlTemplate, LongPtr[i]);
        break;

    case rControlTemplate:
        ctl.dummy = resPtr;
        ctlPCnt = ctl.BcPtr->ctlTemplate.pCount;
        ctlMore = ctl.BcPtr->ctlTemplate.moreFlags;

        switch (ctl.BcPtr->ctlTemplate.procRef) {
        case simpleButtonControl:
            (long) ctl.BcPtr->titleRef = CopyResource(oldFile, newFile, rPString, (long) ctl.BcPtr->titleRef);
            if (ctlPCnt > 7)
                (long) ctl.BcPtr->colorTableRef = CopyResource(oldFile, newFile, rCtlColorTbl, (long) ctl.BcPtr->colorTableRef);
            break;

        case checkControl:
        case radioControl:
            (long) ctl.CBcPtr->titleRef = CopyResource(oldFile, newFile, rPString, ctl.CBcPtr->titleRef);
            if (ctlPCnt > 8)
                (long) ctl.CBcPtr->colorTableRef = CopyResource(oldFile, newFile, rCtlColorTbl, (long) ctl.CBcPtr->colorTableRef);
            break;

        case scrollBarControl:
            if (ctlPCnt > 9)
                (long) ctl.SBcPtr->colorTableRef = CopyResource(oldFile, newFile, rCtlColorTbl, (long) ctl.SBcPtr->colorTableRef);
            break;

        case growControl:
            if (ctlPCnt > 6)
                (long) ctl.GcPtr->colorTableRef = CopyResource(oldFile, newFile, rCtlColorTbl, (long) ctl.GcPtr->colorTableRef);
            break;

        case statTextControl:
          	(long) ctl.BcPtr->titleRef = CopyResource(oldFile, newFile, rTextForLETextBox2, (long) ctl.BcPtr->titleRef);
            break;

        case editLineControl:
          	(long) ctl.LEcPtr->defaultRef = CopyResource(oldFile, newFile, rPString, (long) ctl.LEcPtr->defaultRef);
            break;

        case editTextControl:
            if (ctlPCnt > 12)
                (long) ctl.TEcPtr->styleRef = CopyResource(oldFile, newFile, rStyleBlock, (long) ctl.TEcPtr->styleRef);
            if (ctlPCnt > 14)
                i = ctl.TEcPtr->textDescriptor & 0x0007;
                (long) ctl.TEcPtr->textRef = CopyResource(oldFile, newFile, TEType[i], (long) ctl.TEcPtr->textRef);
            if (ctlPCnt > 20)
				(long) ctl.TEcPtr->colorRef = CopyResource(oldFile, newFile, rCtlColorTbl, (long) ctl.TEcPtr->colorRef);
            break;

        case popUpControl:
            (long) ctl.PMcPtr->menuRef = CopyResource(oldFile, newFile, rMenu, (long) ctl.PMcPtr->menuRef);
            if (ctlPCnt > 9)
                (long) ctl.PMcPtr->colorTableRef = CopyResource(oldFile, newFile, rCtlColorTbl, (long) ctl.PMcPtr->colorTableRef);
            break;

        case listControl:
         	(long) ctl.LcPtr->listRef = CopyResource(oldFile, newFile, rListRef, (long) ctl.LcPtr->listRef);
            if (ctlPCnt > 14)
                (long) ctl.LcPtr->colorTableRef = CopyResource(oldFile, newFile, rCtlColorTbl, (long) ctl.LcPtr->colorTableRef);
			break;

        case pictureControl:
            (long) ctl.PcPtr->pictureRef = CopyResource(oldFile, newFile, rPicture, (long) ctl.PcPtr->pictureRef);
            break;

        case iconButtonControl:
        case 0x07ff0001:
            (long) ctl.IcPtr->iconRef = CopyResource(oldFile, newFile, rIcon, (long) ctl.IcPtr->iconRef);
            if (ctlPCnt > 7)
                (long) ctl.IcPtr->titleRef = CopyResource(oldFile, newFile, rPString, (long) ctl.IcPtr->titleRef);
            if (ctlPCnt > 8)
                (long) ctl.IcPtr->colorTableRef = CopyResource(oldFile, newFile, rCtlColorTbl, (long) ctl.IcPtr->colorTableRef);
            break;

        case thermometerControl:
            if (ctlPCnt > 8)
                (long) ctl.TcPtr->colorTableRef = CopyResource(oldFile, newFile, rCtlColorTbl, (long) ctl.TcPtr->colorTableRef);
            break;

		default:
			break;
        }
        break;

    case rMenuBar:
        MBarPtr = (MenuBarTemplate *) resPtr;
        for (i = 0; MBarPtr->menuRefArray[i] != 0L; i++)
            (long) MBarPtr->menuRefArray[i] = CopyResource(oldFile, newFile, rMenu, (long) MBarPtr->menuRefArray[i]);
        break;

    case rMenu:
        MenuPtr = (MenuTemplate *) resPtr;
        (long) MenuPtr->menuTitleRef = CopyResource(oldFile, newFile, rPString, (long) MenuPtr->menuTitleRef);
        for (i = 0; MenuPtr->itemRefArray[i] != 0L; i++)
            (long) MenuPtr->itemRefArray[i] = CopyResource(oldFile, newFile, rMenuItem, (long) MenuPtr->itemRefArray[i]);
        break;

    case rMenuItem:
        ItemPtr = (MenuItemTemplate *) resPtr;
        if (ItemPtr->itemFlag & 0x0400)
            (long) ItemPtr->itemTitleRef = CopyResource(oldFile, newFile, rItemStruct, (long) ItemPtr->itemTitleRef);
        else
            (long) ItemPtr->itemTitleRef = CopyResource(oldFile, newFile, rPString, (long) ItemPtr->itemTitleRef);
        break;

    case rWindParam1:
        WinPtr = (WinTemplate *) resPtr;
        (long) WinPtr->plTitle = CopyResource(oldFile, newFile, rPString, (long) WinPtr->plTitle);
        if (WinPtr->plColor)
        	(long) WinPtr->plColor = CopyResource(oldFile, newFile, rWindColor, (long) WinPtr->plColor);
		if ((WinPtr->plInDesc & 0x00ff) == 2)
        	(long) WinPtr->plControlList = CopyResource(oldFile, newFile, rControlTemplate, (long) WinPtr->plControlList);
        else if ((WinPtr->plInDesc & 0x00ff) == 9)
			(long) WinPtr->plControlList = CopyResource(oldFile, newFile, rControlList, (long) WinPtr->plControlList);
        break;

    case  rListRef:
		if (getListCtlData(&size, &count, resID, oldFile)) {
	    	tmpPtr.Ptr = (char *) resPtr;
	        for (i = 0; i < count; i++, tmpPtr.Ptr += size)
            	*tmpPtr.lPtr = CopyResource(oldFile, newFile, rPString, *tmpPtr.lPtr);
        }
        break;

    case  rItemStruct:
        StructPtr = (itemStruct *) resPtr;
        (long) StructPtr->itemTitleRef = CopyResource(oldFile, newFile, rPString, (long) StructPtr->itemTitleRef);
        if (StructPtr->itemFlag2 & 0x8000)
            (long) StructPtr->itemIconRef = CopyResource(oldFile, newFile, rIcon, (long) StructPtr->itemIconRef);
        break;

    case rBundle:
		srcPtr.Ptr = resPtr;
		srcPtr.Ptr += 2;
		offset = *srcPtr.wPtr;   /* first we deal with the bundle header */
		srcPtr.Ptr += 2;
		*srcPtr.lPtr = CopyResource(oldFile, newFile, rIcon, *srcPtr.lPtr);
		srcPtr.Ptr = resPtr + offset;
		count = *srcPtr.wPtr;
    	srcPtr.Ptr += 2;            /* since we now have our header info */
		for (i = 0; i < count; i++) {
			size = *srcPtr.wPtr;
			tmpPtr.Ptr = srcPtr.Ptr + 4;
			flag = *tmpPtr.wPtr;
			if (flag > 1) {
				tmpPtr.Ptr = srcPtr.Ptr + 8;
				*tmpPtr.lPtr = CopyResource(oldFile, newFile, rFinderPath, *tmpPtr.lPtr);
			}
			if (flag > 2) {
				tmpPtr.Ptr = srcPtr.Ptr + 16;
				*tmpPtr.lPtr = CopyResource(oldFile, newFile, rIcon, *tmpPtr.lPtr);
			}
			if (flag > 3) {
				tmpPtr.Ptr = srcPtr.Ptr + 24;
				*tmpPtr.lPtr = CopyResource(oldFile, newFile, rIcon, *tmpPtr.lPtr);
			}
			(long) srcPtr.Ptr += size;
		}
		break;

    case rFinderPath:
	    srcPtr.Ptr = resPtr;
		srcPtr.Ptr += 4;
        count = *srcPtr.wPtr;
        srcPtr.Ptr += 2;
        for (i = count; i > 0; i--) {
            *srcPtr.lPtr = CopyResource(oldFile, newFile, rVersion, *srcPtr.lPtr);
            srcPtr.Ptr += 8;
        }
		break;
    }

	HUnlock(copyData);

    resID = copyManager(oldFile, newFile, resType, resID, copyData);

    MoonCursor();

    return resID;
}
